/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import intrinsic.flash.filters.*;

import org.eclipse.swt.*;


public class BevelEffect extends Effect {
	
	public BevelEffect() {
		super();
	}
	
	void createHandle() {
		BevelFilter filter = new BevelFilter();
		if (filter == null) SWT.error(SWT.ERROR_NO_HANDLES);
		object = filter;
	}
	
	public void setAngle(double angle) {
		checkEffect();
		((BevelFilter)object).angle = angle;
	}
	
	public void setSmoothness(double smoothness) {
		checkEffect();
		((BevelFilter)object).strength = (int)((1 - smoothness) * 255);
	}
	
	public void setWidth(double width) {
		checkEffect();
		((BevelFilter)object).distance = width;
	}
}
